/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.google.inject.Inject;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.CompleteAssetDictionary;
import technology.rocketjump.undermount.assets.entities.RenderLayerDictionary;
import technology.rocketjump.undermount.assets.entities.model.AttachmentDescriptor;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.entities.model.EntityChildAssetDescriptor;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.AttachedEntity;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.custom_libgdx.ShaderLoader;
import technology.rocketjump.undermount.rendering.entities.EntityPartRenderStep;
import technology.rocketjump.undermount.rendering.entities.EntityRenderSteps;

public class EntityRenderer {
    private static final float PIXELS_PER_TILE = 64.0f;
    private final float WHITE_PACKED = Color.WHITE.toFloatBits();
    private EntityRenderSteps entityRenderSteps = new EntityRenderSteps();
    private final CompleteAssetDictionary assetDictionary;
    private final RenderLayerDictionary renderLayerDictionary;
    private boolean usingNormalMapInverseShader = false;
    private ShaderProgram defaultShader;
    private ShaderProgram inverseNormalShader;

    @Inject
    public EntityRenderer(CompleteAssetDictionary completeAssetDictionary, RenderLayerDictionary renderLayerDictionary) {
        this.assetDictionary = completeAssetDictionary;
        this.renderLayerDictionary = renderLayerDictionary;
        FileHandle vertexShaderFile = Gdx.files.classpath("shaders/default_vertex_shader.glsl");
        FileHandle fragmentShaderFile = Gdx.files.classpath("shaders/invert_normal_map_red_channel_fragment_shader.glsl");
        this.inverseNormalShader = ShaderLoader.createShader(vertexShaderFile, fragmentShaderFile);
    }

    public void render(Entity entity, Batch basicSpriteBatch, RenderMode renderMode, Entity parentEntity, Color overrideColor) {
        if (renderMode.equals((Object)RenderMode.NORMALS) && overrideColor != null) {
            return;
        }
        if (this.defaultShader == null) {
            this.defaultShader = basicSpriteBatch.getShader();
        }
        this.entityRenderSteps.clear();
        LocationComponent locationComponent = entity.getLocationComponent();
        Vector2 worldPosition = locationComponent.getWorldPosition().cpy();
        EntityAsset baseAsset = entity.getPhysicalEntityComponent().getBaseAsset();
        this.addToRenderParts(baseAsset, entity, worldPosition, this.assetDictionary, worldPosition, parentEntity);
        this.addAttachedEntitiesAsRenderSteps(entity);
        for (EntityPartRenderStep renderStep : this.entityRenderSteps.clone().getRenderSteps()) {
            this.render(renderStep, basicSpriteBatch, locationComponent, renderMode, overrideColor);
        }
        if (renderMode.equals((Object)RenderMode.NORMALS) && this.usingNormalMapInverseShader) {
            this.usingNormalMapInverseShader = false;
            basicSpriteBatch.setShader(this.defaultShader);
        }
    }

    private void addAttachedEntitiesAsRenderSteps(Entity entity) {
        for (AttachedEntity attachedEntity : entity.getAttachedEntities()) {
            this.entityRenderSteps.addAttachedEntity(attachedEntity);
        }
        for (Map.Entry entry : this.entityRenderSteps.getAttachedEntities()) {
            AttachmentDescriptor attachment = this.entityRenderSteps.getAttachmentPoint((EntityAssetType)entry.getKey());
            if (attachment == null) {
                System.err.println("Could not find position to show attached entity (" + entry.getKey() + ")");
                continue;
            }
            Vector2 attachmentWorldPosition = attachment.getWorldPosition();
            EntityPartRenderStep attachedRenderStep = new EntityPartRenderStep(null, attachmentWorldPosition, attachmentWorldPosition, entity);
            attachedRenderStep.setOtherEntity((Entity)entry.getValue());
            int renderLayer = this.renderLayerDictionary.getRenderingLayer(entity.getType(), entity.getLocationComponent().getOrientation(), (EntityAssetType)entry.getKey());
            if (attachment.getOverrideRenderLayer() != null) {
                renderLayer += attachment.getOverrideRenderLayer().intValue();
            }
            this.entityRenderSteps.addPartToRender(renderLayer, attachedRenderStep);
        }
    }

    private void addToRenderParts(EntityAsset asset, Entity entity, Vector2 parentPosition, CompleteAssetDictionary assetDictionary, Vector2 baseEntityPosition, Entity parentEntity) {
        SpriteDescriptor spriteDescriptor = asset.getSpriteDescriptors().get((Object)entity.getLocationComponent().getOrientation());
        if (spriteDescriptor == null) {
            return;
        }
        int renderLayer = this.renderLayerDictionary.getRenderingLayer(entity.getType(), entity.getLocationComponent().getOrientation(), asset.getType());
        if (asset.getOverrideRenderLayer() != null) {
            renderLayer += asset.getOverrideRenderLayer().intValue();
        }
        this.entityRenderSteps.addPartToRender(renderLayer, new EntityPartRenderStep(spriteDescriptor, parentPosition, baseEntityPosition, entity));
        for (EntityChildAssetDescriptor childAssetDescriptor : spriteDescriptor.getChildAssets()) {
            PlantEntityAttributes attributes;
            EntityAsset childAsset = this.getAssetByDescriptor(entity, childAssetDescriptor, assetDictionary);
            if (childAsset == null || childAsset.getSpriteDescriptors().isEmpty() || entity.getType().equals((Object)EntityType.PLANT) && (attributes = (PlantEntityAttributes)entity.getPhysicalEntityComponent().getAttributes()).getLeafColorChangeAmount() < 0.0f) continue;
            Vector2 childOffsetWorldPosition = childAssetDescriptor.getOffsetPixels().cpy().scl(spriteDescriptor.getScale() * 0.015625f);
            this.addToRenderParts(childAsset, entity, parentPosition.cpy().add(childOffsetWorldPosition), assetDictionary, baseEntityPosition, parentEntity);
        }
        if (!spriteDescriptor.getAttachmentPoints().isEmpty()) {
            this.entityRenderSteps.addAttachmentPoints(spriteDescriptor.getAttachmentPoints(), parentPosition.cpy());
        }
        if (!spriteDescriptor.getParentEntityAssets().isEmpty() && parentEntity != null) {
            for (EntityChildAssetDescriptor descriptorForParentAsset : spriteDescriptor.getParentEntityAssets()) {
                EntityAsset parentEntityAsset = this.getAssetByDescriptor(parentEntity, descriptorForParentAsset, assetDictionary);
                if (parentEntityAsset == null || parentEntityAsset.getSpriteDescriptors().isEmpty()) continue;
                Vector2 offsetWorldPosition = descriptorForParentAsset.getOffsetPixels().cpy().scl(spriteDescriptor.getScale() * 0.015625f);
                this.addToRenderParts(parentEntityAsset, parentEntity, parentPosition.cpy().add(offsetWorldPosition), assetDictionary, baseEntityPosition, null);
            }
        }
    }

    private EntityAsset getAssetByDescriptor(Entity entity, EntityChildAssetDescriptor assetDescriptor, CompleteAssetDictionary assetDictionary) {
        EntityAsset asset = assetDescriptor.getSpecificAssetName() != null ? assetDictionary.getByUniqueName(assetDescriptor.getSpecificAssetName(), entity.getType()) : entity.getPhysicalEntityComponent().getTypeMap().get(assetDescriptor.getType());
        if (asset != null && assetDescriptor.getOverrideRenderLayer() != null) {
            asset.setOverrideRenderLayer(assetDescriptor.getOverrideRenderLayer());
        }
        return asset;
    }

    private void render(EntityPartRenderStep renderStep, Batch spriteBatch, LocationComponent locationComponent, RenderMode renderMode, Color overrideColor) {
        PlantEntityAttributes plantEntityAttributes;
        if (renderStep.isAnotherEntity()) {
            renderStep.getOtherEntity().getLocationComponent().setWorldPosition(renderStep.getAbsolutePosition(), false);
            EntityRenderSteps cloned = this.entityRenderSteps.clone();
            this.render(renderStep.getOtherEntity(), spriteBatch, renderMode, renderStep.getEntity(), overrideColor);
            this.entityRenderSteps = cloned;
            renderStep.getOtherEntity().getLocationComponent().setWorldPosition(null, false);
            return;
        }
        if (overrideColor == null) {
            spriteBatch.setColor(this.WHITE_PACKED);
        } else {
            spriteBatch.setColor(overrideColor);
        }
        SpriteDescriptor spriteDescriptor = renderStep.getSpriteDescriptor();
        EntityAttributes attributes = renderStep.getEntity().getPhysicalEntityComponent().getAttributes();
        if (renderMode.equals((Object)RenderMode.DIFFUSE)) {
            Color color;
            if (spriteDescriptor.getColoringLayer() != null && overrideColor == null && (color = attributes.getColor(spriteDescriptor.getColoringLayer())) != null) {
                spriteBatch.setColor(color);
            }
            if (this.usingNormalMapInverseShader) {
                this.usingNormalMapInverseShader = false;
                spriteBatch.setShader(this.defaultShader);
            }
        } else if (renderMode.equals((Object)RenderMode.NORMALS)) {
            if (spriteDescriptor.isFlipX() && !this.usingNormalMapInverseShader) {
                this.usingNormalMapInverseShader = true;
                spriteBatch.setShader(this.inverseNormalShader);
            } else if (!spriteDescriptor.isFlipX() && this.usingNormalMapInverseShader) {
                this.usingNormalMapInverseShader = false;
                spriteBatch.setShader(this.defaultShader);
            }
        }
        float spriteScale = spriteDescriptor.getScale();
        if (attributes instanceof PlantEntityAttributes && (plantEntityAttributes = (PlantEntityAttributes)attributes).getSpecies().getPlantType().equals((Object)PlantSpeciesType.SHRUB)) {
            if (!plantEntityAttributes.isFullyGrown()) {
                spriteScale *= 0.5f + plantEntityAttributes.getGrowthAmount() / 2.0f;
            }
            if (spriteDescriptor.getColoringLayer().equals((Object)ColoringLayer.FRUIT_COLOR) && spriteDescriptor.getColoringLayer() != null && plantEntityAttributes.getFruitState() != null && plantEntityAttributes.getFruitState().equals((Object)PlantEntityAttributes.FruitState.BUDDING)) {
                spriteScale *= plantEntityAttributes.getFruitGrowthAmount();
            }
        }
        Sprite sprite = null;
        if (spriteDescriptor.getIsAnimated()) {
            Array<Sprite> animatedSprites = spriteDescriptor.getAnimatedSprites(renderMode);
            if (animatedSprites != null && animatedSprites.size > 0) {
                float animationProgress = renderStep.getEntity().getPhysicalEntityComponent().getAnimationProgress();
                int frameSelection = Math.round(animationProgress * (float)animatedSprites.size);
                if (frameSelection >= animatedSprites.size) {
                    frameSelection = animatedSprites.size - 1;
                } else if (frameSelection <= 0) {
                    frameSelection = 0;
                }
                sprite = animatedSprites.get(frameSelection);
            }
        } else {
            sprite = spriteDescriptor.getSprite(renderMode);
        }
        if (sprite == null) {
            if (renderMode.equals((Object)RenderMode.NORMALS)) {
                return;
            }
            throw new RuntimeException("Null sprite from descriptor with filename " + spriteDescriptor.getFilename() + " in " + this.getClass().getName());
        }
        Vector2 spriteWorldSize = new Vector2(sprite.getWidth() * spriteScale / 64.0f, sprite.getHeight() * spriteScale / 64.0f);
        if (locationComponent.getRotation() == 0.0f) {
            spriteBatch.draw(sprite, renderStep.getAbsolutePosition().x - spriteWorldSize.x / 2.0f, renderStep.getAbsolutePosition().y - spriteWorldSize.y / 2.0f, spriteWorldSize.x, spriteWorldSize.y);
        } else {
            Vector2 rotationOrigin = new Vector2(spriteWorldSize.x / 2.0f, 0.25f);
            spriteBatch.draw(sprite, renderStep.getAbsolutePosition().x - spriteWorldSize.x / 2.0f, renderStep.getAbsolutePosition().y - spriteWorldSize.y / 2.0f, rotationOrigin.x, rotationOrigin.y, spriteWorldSize.x, spriteWorldSize.y, 1.0f, 1.0f, locationComponent.getRotation());
        }
    }
}

